﻿package com {
	import caurina.transitions.*;
	import gs.*;
	import gs.easing.*;
	
	import flash.display.*;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.system.Security;

	public class YouTubePlayer extends MovieClip{
		public var player:Object; //The YOUTUBE player
		private var _loader:Loader; //The loader to get the player
		private var curMovie : MovieClip;
		private var _root : MovieClip;
		
		private var DEF_WIDTH : int = 640;
		private var DEF_HEIGHT : int = 360;
		public const DEF_QUALITY : Array = new Array({name:'small', qname:'360p', width:640, height:360},
		{name:'medium', qname:'360p',width:640,height:360},
		{name:'large', qname:'480p', width:854,height:480},
		{name:'hd720', qname:'720p', width:1280,height:720}
		);

		private var quality_name : String = new String(DEF_QUALITY[0].name);

		private var _width : int = DEF_QUALITY[0].width;
		private var _height : int = DEF_QUALITY[0].height;

		private var doPlay : Boolean = false;
		private var fullScreen : Boolean = false;	

		////////////////////////////  CONSTRUCTOR /////////////////////////////////////////////////
		//////////////////////  _rt : MovieClip - parent MovieClip;
		//						idVid : String - id of video on YouTube;
		//						_doPlay : Boolean - play after creating or not
		//						x,y - position of player
		//						w,h - resolution of player
		//						fs - allow fullscreen 
		///////////////////////////////////////////////////////////////////////////////////////////
		public function YouTubePlayer (	_rt : MovieClip, rootMovie:MovieClip,
										idVid : String, 
										_doPlay : Boolean = false,
										x : int = 0, y : int = 0,
										w : int = 640, h : int = 360,
										fs : Boolean = false
										) : void {
			curMovie = _rt;
			_root = rootMovie
			curMovie.addChild(this);
			fullScreen = fs;

			doPlay = _doPlay;
			
			//Security.allowInsecureDomain("*");
			//Security.allowDomain('*');  
			Security.allowInsecureDomain("http://www.youtube.com");
			Security.allowDomain('http://s.ytimg.com');  
			Security.allowDomain('http://i4.ytimg.com');  
			Security.allowDomain('http://i.ytimg.com'); 
			Security.allowDomain('http://img.youtube.com/'); 
			
			setPosition(x, y);
			_width = w;	
			_height = h;
				
			_loader = new Loader();
			this.addChild(_loader);

			_loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
			//_loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
			_loader.load(new URLRequest("http://www.youtube.com/v/"+idVid+"?version=3"));

			//loadVideo(idVid);
		}

		/////////////////////////////////// FORM REQUEST ///////////////////////////////////
		private function formRequest(param : String) : URLRequest {
		/*	var part1 : String = new String("http://www.youtube.com/v/");
			var part2 : String = new String("?version=3");
			if (fullScreen) {
				part2 += '&fs=1';
			}
		
			if ((param) && (param != '') && (param != ' ')) {
				return new URLRequest(part1 + param + part2);
			} else {	
				return null;
				}*/
				
				return null;
		}
		
		////////////////////////////////// GET THUMBNAIL URL /////////////////
		public function getThumbURL(param : String) : String {
			var part1 : String = new String("http://img.youtube.com/vi/");
			if ((param) && (param != '') && (param != ' ')) {
				return new String(part1 + param);
			} else {	return null; }
		}

		///////////////////////////////// PLAYER EVENTS ///////////////////////////
		private function onLoaderInit(event:Event):void {
			//_loader.contentLoaderInfo.removeEventListener(Event.INIT, onLoaderInit);
			
			_loader.content.addEventListener("onReady", onPlayerReady);
			_loader.content.addEventListener("onError", onPlayerError);
			_loader.content.addEventListener("onStateChange", onPlayerStateChange);
			_loader.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
		}

		private function onPlayerReady(event:Event):void {
			
			player = _loader.content;
			
			if (player) {
				//setSizeP(_width, _height);
				player.setSize(_width, _height);
			}
		}
		
		public function loadVideo(param : String) : void {
		
			 TweenMax.to(player, 0.5, { alpha:0, ease:Expo.easeOut, onComplete:function():void {
				 player.cueVideoById(param);
				 TweenMax.to(player, 1, {alpha:1, ease:Expo.easeOut});
				 
				 }});
			
		//	player.seekTo(0, true);
		//	player.stopVideo();
				//_loader.load(new URLRequest("http://www.youtube.com/v/"+param+"?version=3"));
			
		}
		
		private function onPlayerStateChange(event:Event):void {
		//	trace("State is", Object(event).data);
		
			switch (Object(event).data) {
				case 0 :	
				break;
			
				case 1 :
				trace("PLAY  PLAY", Object(event).data);
				//TweenMax.to(_root.footer.fPlane.volControl, 0.4, { alpha:0,ease:Expo.easeIn});
				_root.program.soundMute();
				break;
				
				case 2 :
					trace("STOP  STOP", Object(event).data);
				_root.program.soundUpdate();
				//TweenMax.to(_root.footer.fPlane.volControl, 2, { alpha:1,ease:Expo.easeIn});
				break;
				
				case 3 :
					trace("LOAD  LOAD", Object(event).data);
					//TweenMax.to(_root.footer.fPlane.volControl, 0.4, { alpha:0,ease:Expo.easeIn});
					//_root.program..soundMute();
				break;
				
				case 5 :
				break;
				
				case -1 :
				trace("-1111111111111111111", Object(event).data);
				//TweenMax.to(_root.footer.fPlane.volControl, 1, { alpha:1,ease:Expo.easeIn});
				_root.program.soundUpdate();
				break;
			}
		}

		private function onVideoPlaybackQualityChange(event:Event):void{

		}

		private function onPlayerError(event:Event):void {
			trace("player error:" + Object(event).data + "\r");
		}

		///////////////////////////////// END EVENTS /////////////////////////////////

		/////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////  EXTERNAL CONTROL ////////////////////////////////
		/////////////////////////////////////////////////////////////////////////////////
		public function destroy() : void {
			if (player){
				player.destroy();
			}
		}

	

		public override function play() : void {
			if (player) {
				player.playVideo();
			}
		}

		public override function stop() : void {
			if (player) {
				player.stopVideo();
			}
		}

		public function pause() : void {
			if (player) {
				player.pauseVideo();
			}
		}

		//////////////////////// SIZE /////////////////////////
		public function setSizeP(param1 : int, param2 : int) : Boolean {
			/*if (player) {
				if ((param1 > 0) && (param2 > 0)) {
					player.setSize(param1, param2);
					return true;
				} else {	return false;	}
			} else {	return false;	}*/
			return true;
		}

	
		//////////////////////// QUALITY /////////////////////////
		private function set playbackQuality(param : String) : void {
			if ((param) && (param != '') && (param != ' ')) {
				Quality = param;
			}
		}

		private function get playbackQuality() : String {
			return player.getPlaybackQuality();
		}

		public function set Quality(_name : String) : void {
			for (var i : int = 0;i < (DEF_QUALITY as Array).length; i++) {
				if (_name == DEF_QUALITY[i].name) {
					quality_name = _name;
					player.setPlaybackQuality(_name);
				}
			}
		}

		public function get Quality() : String {
			return quality_name;
		}

		//////////////////////// POSITION /////////////////////////
		public function setPosition(param1 : int, param2 : int) : void {
			this.x = param1;
			this.y = param2;
		}
		/////////////////////////////// END EXTERNAL CONTROL //////////////////////////////////
	}
}